#include "MTInfoWindow.h"
#include "MTApplication.h"
#include "MTExceptions.h"

const UInt32		MTInfoWindow::kInfoWindowWidth = 350;
const UInt32		MTInfoWindow::kInfoWindowElementHeight = 12;
const char			MTInfoWindow::kSpaceBuffer[256] =	"                                                  "
														"                                                  "
														"                                                  "
														"                                                  "
														"                                                  "
														"     ";	// 255 spaces
MTFontStyle			MTInfoWindow::kInfoWindowFontStyle("\pMonaco", 9);

MTInfoWindow::MTInfoWindow()
{
	maxItemTitleLength = 0;
	
	ownerName.clear();
}

MTInfoWindow::~MTInfoWindow()
{
	
}

void MTInfoWindow::HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers)
{
	if(AutoHandleKeyEvent(theEvent, charCode, keyCode, modifiers))
	{
		
	}
}

void MTInfoWindow::ObjectUpdated(UInt32 type, UInt32 object)
{
	#pragma unused (type)
	#pragma unused (object)
}

void MTInfoWindow::ObjectDeleted(UInt32 type, UInt32 object)
{
	#pragma unused (type)
	#pragma unused (object)
}

void MTInfoWindow::RecieveMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageData)
	
	switch(messageType)
	{
		case 'EXPT':
			DoExport();
			break;
	}
}

UInt8 MTInfoWindow::SupportsMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageData)
	
	switch(messageType)
	{
		case 'EXPT':
			return SupportsExport();
	}
	
	return 0;
}

void MTInfoWindow::AttachDataTemplate(MTInfoWindowDataTemplate * dataTemplate)
{
	data.entries.resize(dataTemplate->numEntries);
	
	for(UInt32 i = 0; i < dataTemplate->numEntries; i++)
	{
		data.entries[i].title = dataTemplate->entries[i].title;
		data.entries[i].data.clear();
	}
}

void MTInfoWindow::SetEntryData(UInt32 id, const char * buf, UInt8 redraw)
{
	data.entries[id].data = buf;
	
	if(redraw && theWindow)
		HandleUpdateEvent();
}

void MTInfoWindow::SetEntryTitle(UInt32 id, const char * buf, UInt8 redraw)
{
	data.entries[id].title = buf;
	
	if(redraw && theWindow)
		HandleUpdateEvent();
}

void MTInfoWindow::SetEntryDivider(UInt32 id, UInt8 divider, UInt8 redraw)
{
	data.entries[id].divider = divider;
	
	if(redraw && theWindow)
		HandleUpdateEvent();
}

void MTInfoWindow::DrawElement(UInt32 id, SInt32 x, SInt32 y, UInt32 flags)
{
	char		buf[4096];
	UInt32		length;
	Rect		where;
	SInt32		width;
	int			numSpaces;
	MTFontSaver	fontSaver;
	
	if(id >= GetListLength())
		return;
	
	GetWindowBounds(theWindow, kWindowContentRgn, &where);
	width = where.right - where.left - kScrollBarSize;
	
	numSpaces = maxItemTitleLength - data.entries[id].title.length();
	
	if(numSpaces > 255)
		throw MTRangeException("Entry title longer than 255 characters");
	
	if((numSpaces > 0) && maxItemTitleLength)
		std::sprintf(buf, "%s:%.*s %s", data.entries[id].title.c_str(), numSpaces, kSpaceBuffer, data.entries[id].data.c_str());
	else
		std::sprintf(buf, "%s: %s", data.entries[id].title.c_str(), data.entries[id].data.c_str());
	
	kInfoWindowFontStyle.SetCurrent();
	RGBForeColor(&kBlackColor);
	
	if(flags & kListItemSelectedFlag)
		TextMode(notSrcCopy);
	
	length = std::strlen(buf);
	
	while((TextWidth(buf, 0, length) > width) && length)
		length--;
	
	MoveTo(x + 3, y + 10);
	DrawText(buf, 0, length);
}

void MTInfoWindow::HandleListDoubleClick(UInt32 selection)
{
	#pragma unused (selection)
}

void MTInfoWindow::RecalculateListSpacing(void)
{
	maxItemTitleLength = 0;
	
	for(UInt32 i = 0; i < data.entries.size(); i++)
	{
		UInt32	tempLength = data.entries[i].title.length();
		
		if(tempLength > maxItemTitleLength)
			maxItemTitleLength = tempLength;
	}
}

void MTInfoWindow::GetWindowName(StringPtr theString)
{
	char	buf[256];
	
	std::sprintf(buf, "Info: %s", ownerName.c_str());
	
	CopyCStringToPascal(buf, theString);
}
